/* 
*
*	File: Type1GlyphBBoxCalculator.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.GlyphBBoxOutlineConsumer;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.GlyphBBoxCalculator;
import com.adobe.fontengine.font.FontData;

/**
 * computes the unhinted bounding boxes for glyphs with type1 glyph descriptions.
 * 
 * <p>An instance of this class can be reused with multiple glyphs in multiple
 * fonts.</p>
 * 
 * <h4>Synchronization</h4>
 * 
 * This class is synchronized. Only one thread will be allowed into the calculateBBox
 * method at a time.
 */
final public class Type1GlyphBBoxCalculator implements GlyphBBoxCalculator{
    private final GlyphBBoxOutlineConsumer consumer; 
    private final Type1OutlineParser parser = new Type1OutlineParser();
    
    public Type1GlyphBBoxCalculator(Matrix finalMatrix)
    {
        consumer = new GlyphBBoxOutlineConsumer(finalMatrix);
    }
    
    public synchronized Rect calculateBBox(FontData font, int glyphID) 
    throws InvalidGlyphException, UnsupportedFontException
    { 
        consumer.reset(); 
        parser.parse((Type1Font)font, glyphID, consumer);
        return consumer.getBBox();
        
    }
}
