/*
 *
 *	File: MemoryFont.java
 *
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.fontmanagement;

import java.util.Map;

import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;

final public class MemoryFont extends FontImpl {
  static final long serialVersionUID = 1;
  
  FontData fontRef;
  
  public MemoryFont(FontData fontData) {
    this.fontRef = fontData;
  }
  
  public int hashCode() {
    return fontRef.hashCode();
  }
  
  public boolean equals(Object obj) {
    if (obj != null) {
      if (this == obj) {
        return true; }
      if (obj instanceof MemoryFont) {
        if (this.fontRef.equals(((MemoryFont)obj).fontRef)) {
          return true; }}}
    return false;
  }
  
  public String toString() {
    return fontRef + " = " + fontRef.toString();
  }
  
  protected FontData retrieveFontData() 
  throws InvalidFontException, UnsupportedFontException {
    return fontRef;
  }

  /* These are the cache support methods. They are noops for MemoryFont
   * because MemoryFonts are not cached.
   */
  public String getCanonicalPath()
  {
    return null;
  }

  public long getLength()
  {
    return 0;
  }

  public long getLastModified()
  {
    return 0;
  }

  public Object getCachedFontDescription(String key)
  {
    return null;
  }

  public Map<String, Object> getCachedFontDescriptionMap()
  {
    return null;
  }

  public void setCachedFontDescription(String key, Object value)
  {
  }
}
