/**
 * 
 */
package com.adobe.fontengine.fontmanagement.fxg;

/**
 * A search request for a font using FXG terms.
 */
public class FXGFontSearchAttributes 
{
	/**
	 * 
	 */
	private final String familyName;
	/**
	 * 
	 */
	private final boolean isBold;
	/**
	 * 
	 */
	private final boolean isItalic;

	/**
	 * @param platformName
	 * @param isBold
	 * @param isItalic
	 */
	public FXGFontSearchAttributes(String platformName, boolean isBold, boolean isItalic) 
	{
		super();
		if (platformName == null)
		{
			throw new NullPointerException("Platoform name can't be null");
		}
		this.familyName = platformName;
		this.isBold = isBold;
		this.isItalic = isItalic;
	}

	/**
	 * Get the font family name used for FXG.
	 * @return the font family name
	 */
	public String getFamilyName() 
	{
		return familyName;
	}

	/**
	 * Tests whether the font is bold in FXG terms.
	 * @return <code>true</code> if the font is bold; <code>false</code> otherwise
	 */
	public boolean isBold() 
	{
		return isBold;
	}

	/**
	 * Tests whether the font is italic in FXG terms.
	 * @return <code>true</code> if the font is italic; <code>false</code> otherwise
	 */
	public boolean isItalic() 
	{
		return isItalic;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() 
	{
		final int prime = 31;
		int result = 1;
		result = prime * result + (isBold ? 1231 : 1237);
		result = prime * result + (isItalic ? 1231 : 1237);
		result = prime * result	+ ((familyName == null) ? 0 : familyName.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) 
	{
		if (this == obj)
		{
			return true;
		}
		if (obj == null)
		{
			return false;
		}
		if (!(obj instanceof FXGFontSearchAttributes))
		{
			return false;
		}
		final FXGFontSearchAttributes other = (FXGFontSearchAttributes) obj;
		if (isBold != other.isBold)
		{
			return false;
		}
		if (isItalic != other.isItalic)
		{
			return false;
		}
		if (!familyName.equals(other.familyName))
		{
			return false;
		}
		return true;
	}
	
	public String toString()
	{
		return new String(this.familyName + (this.isBold ? ", bold" : "") + (this.isItalic ? ", italic" : ""));
	}
}
