/*
 *
 *	File: PostscriptFontDescription.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 * 
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.fontmanagement.platform;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.FontDescription;
import com.adobe.fontengine.fontmanagement.Platform;

/**
 * A platform name description of a font.  This description can be used for looking up fonts.
 */
final public class PlatformFontDescription extends FontDescription
{
	static final long serialVersionUID = 1;

	private final Platform platform;
	private final ULocale locale;

	private final String platformFamilyName;

	/**
	 * Constructor
	 * @param platform the platform that this description is for
	 * @param platformFamilyName the platform name
	 */
	public PlatformFontDescription(Platform platform, ULocale locale, 
			String platformFamilyName)
	{
		if (platform == null || locale == null || platformFamilyName == null)
		{
			throw new NullPointerException("Platform, Locale, and Platform Name must not be null");
		}
		this.platform = platform;
		this.locale = locale;

		this.platformFamilyName = platformFamilyName;
	}

	/**
	 * Get the platform that this description is for.
	 * @return the platform that this description is for
	 */
	public Platform getPlatform()
	{
		return this.platform;
	}

	/**
	 * Get the platform that this description is for.
	 * @return the platform that this description is for
	 */
	public ULocale getLocale()
	{
		return this.locale;
	}

	/**
	 */
	public String getPlatformName() 
	{
		return platformFamilyName;
	}

	public int hashCode() 
	{
		final int prime = 31;
		int result = 1;
		result = prime * result + locale.hashCode();
		result = prime * result	+ platform.hashCode();
		result = prime * result + platformFamilyName.hashCode();
		return result;
	}

	public boolean equals(Object obj) 
	{
		if (this == obj)
		{
			return true;
		}
		if (obj == null)
		{
			return false;
		}
		if (!(obj instanceof PlatformFontDescription))
		{
			return false;
		}
		final PlatformFontDescription other = (PlatformFontDescription) obj;
		if (locale == null) 
		{
			if (other.locale != null)
			{
				return false;
			}
		} else if (!locale.equals(other.locale))
			return false;
		if (platform == null) 
		{
			if (other.platform != null)
			{
				return false;
			}
		} 
		else if (!platform.equals(other.platform))
		{
			return false;
		}
		if (platformFamilyName == null) 
		{
			if (other.platformFamilyName != null)
			{
				return false;
			}
		} else if (!platformFamilyName.equals(other.platformFamilyName))
		{
			return false;
		}
		return true;
	}
	
	public String toString()
	{
		return new String("[" + this.platform + ", " + this.locale + "] - " + this.platformFamilyName);
	}
}
