/**
 * 
 */
package com.adobe.fontengine.fontmanagement.platform;

/**
 * @author sgill
 *
 */
public class PlatformFontSearchAttributes 
{
	private final String platformName;

	/**
	 * @param platformName
	 */
	public PlatformFontSearchAttributes(String platformName) 
	{
		super();
		if (platformName == null)
		{
			throw new NullPointerException("Platoform name can't be null");
		}
		this.platformName = platformName;
	}

	/**
	 */
	public String getPlatformName() 
	{
		return platformName;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() 
	{
		final int prime = 31;
		int result = 1;
		result = prime * result	+ ((platformName == null) ? 0 : platformName.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) 
	{
		if (this == obj)
		{
			return true;
		}
		if (obj == null)
		{
			return false;
		}
		if (!(obj instanceof PlatformFontSearchAttributes))
		{
			return false;
		}
		final PlatformFontSearchAttributes other = (PlatformFontSearchAttributes) obj;
		if (!platformName.equals(other.platformName))
		{
			return false;
		}
		return true;
	}
}
