/*
 *
 *	File: PostscriptFontDescription.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 * 
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.fontmanagement.postscript;

import com.adobe.fontengine.font.FontDescription;

/**
 * A description of a font in terms of Postscript.  This Postscript font description
 * can be used for looking up fonts.
 */
final public class PostscriptFontDescription extends FontDescription
{
    static final long serialVersionUID = 1;

    private final String psName;
    
    public PostscriptFontDescription(String psName)
    {
        this.psName = psName;
    }
    
    public String getPSName()
    {
        return psName;
    }
    
    public int hashCode()
    {
        return psName.hashCode();
    }
    
    public boolean equals(Object obj)
    {
        if (obj != null)
        {
            if (this == obj)
            {
                return true;
            }
            else if (obj instanceof PostscriptFontDescription)
            {
                return psName.equals(((PostscriptFontDescription)obj).psName);
            }
        }
        return false;
    }

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return this.psName;
	}
}
