/*
*
*	File: FormattingException.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/

package com.adobe.fontengine.inlineformatting;

import com.adobe.fontengine.FontEngineException;

/**
 * FormattingException.
 * 
 * Thrown by inline formatters when some error occurred 
 * during formatting. For instances of this class, the cause generally 
 * provides a more specific indication of the failure.
 */

public class FormattingException extends FontEngineException
{
    static final long serialVersionUID = 1;

    final protected int start;
    final protected int limit;
   
    public FormattingException(int start, int limit)
    {
        super();
        this.start = start;
        this.limit = limit;
    }


    public FormattingException(String message, int start, int limit)
    {
        super(message);
        this.start = start;
        this.limit = limit;
    }

    public FormattingException(String message, Throwable cause, int start, int limit)
    {
        super(message, cause);
        this.start = start;
        this.limit = limit;
    }
    
    public FormattingException(Throwable cause, int start, int limit)
    {
        super(cause);
        this.start = start;
        this.limit = limit;
    }
    
    /**
     * @return the start point in the <code>AttributedRun</code> that caused the exception.
     */
    public int getStart()
    {
        return this.start;
    }
    
    /**
     * @return the limit point in the <code>AttributedRun</code> that caused the exception.
     */
    public int getLimit()
    {
        return this.limit;
    }
    
    public String toString()
    {
        return super.toString() + " (start=" + start + ", limit=" + limit + ")";
    }
}
