/*
*
*	File: CSSPDF16GenericFontFamily.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/
package com.adobe.fontengine.inlineformatting.css20;



/**
 * This class provides an enumeration of the possible values for CSS generic font families.
 * 
 * <h4>Concurrency</h4>
 *  
 * Instances of this class are immutable after construction and contain no mutable static
 * data. Therefore, they are threadsafe.
 */
final public class CSS20GenericFontFamily
{
    private final String name;

    private CSS20GenericFontFamily (String name)
    {
        // this class provides an enum
        this.name = name.intern();
    }
    
    /**
     * Get the name of the generic family.
     * @return the name of the generic family
     */
    public String name()
    {
        return this.name;
    }
    
    /**
     * Parse the text and return the CSS20GenericFontFamily object which is represented if any.
     * 
     * @param text textual representation of the generic font family
     * @return CSS20GenericFontFamily represented by the text value
     */
    public static CSS20GenericFontFamily parse(String text)
    {
        if ("serif".equals(text))
        {
            return CSS20GenericFontFamily.SERIF;
        }
        if ("sans-serif".equals(text))
        {
            return CSS20GenericFontFamily.SANS_SERIF;
        }
        if ("cursive".equals(text))
        {
            return CSS20GenericFontFamily.CURSIVE;
        }
        if ("fantasy".equals(text))
        {
            return CSS20GenericFontFamily.FANTASY;
        }
        if ("monospace".equals(text))
        {
            return CSS20GenericFontFamily.MONOSPACE;
        }
        return null;
    }
    
    /**
     * The "serif" CSS generic font family.
     */
    public static final CSS20GenericFontFamily SERIF = new CSS20GenericFontFamily("serif");

    /**
     * The "sans-serif" CSS generic font family.
     */
    public static final CSS20GenericFontFamily SANS_SERIF = new CSS20GenericFontFamily("sans-serif");

    /**
     * The "cursive" CSS generic font family.
     */
    public static final CSS20GenericFontFamily CURSIVE = new CSS20GenericFontFamily("cursive");
 
    /**
     * The "fantasy" CSS generic font family.
     */
    public static final CSS20GenericFontFamily FANTASY = new CSS20GenericFontFamily("fantasy");

    /**
     * The "monospace" CSS generic font family.
     */
    public static final CSS20GenericFontFamily MONOSPACE = new CSS20GenericFontFamily("monospace");
}