/*
*
*	File: FamilyNameNormalizer.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/
package com.adobe.fontengine.inlineformatting.css20;

import java.io.Serializable;

/**
 * This interface is what must be implemented to over ride the default font family name
 * normalization used by the CSS20FontSet.
 */
public interface FamilyNameNormalizer extends Serializable
{
    /**
     * This method takes a font family name and a normalization system is applied to it for
     * use by the CSS20FontSet in searching for fonts.  Family names that are identical with
     * normalization are treated as being identical for all uses by the CSS20FontSet.
     * @param familyName font family name to normalize
     * @return normalized font family name
     */
    public String normalize(String familyName);
}
