/*
 * File: GurmukhiFormatter.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.fontengine.inlineformatting.AttributedRun;

public class GurmukhiFormatter extends IndicFormatter {

  protected int splitVowelsAndNormalize (AttributedRun run, int start, int limit) {
    return limit;
  }

  protected int nukta () {
    return 0x0A3C;
  }

  protected int virama () {
    return 0xA4D;
  }

  protected boolean isSatelliteWhenInitial (int usv) {
    return false;
  }

  protected boolean isConsonant (int usv) {
    return (   0xA15 <= usv && usv <= 0xA39
            || 0xA59 <= usv && usv <= 0xA5E
            || 0x25cc == usv);
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#hasNukta(int)
   */
  protected boolean hasNukta (int usv) {
    return (   0xA36 == usv
            || 0xA59 == usv
            || 0xA5A == usv
            || 0xA5B == usv
            || 0xA5E == usv);
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#removeNukta(int)
   */
  protected int removeNukta (int usv) {
    switch (usv) {
    case 0xA36: return 0xA38;
    case 0xA59: return 0xA16;
    case 0xA5A: return 0xA17;
    case 0xA5B: return 0xA1C;
    case 0xA5E: return 0xA2B;
    default:    return usv; }
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#isMark(int)
   */
  protected boolean isMark (int usv) {
    return (   0xA01 <= usv && usv <= 0xA03
            || 0xA3E <= usv && usv <= 0xA4C 
            || 0xA70 <= usv && usv <= 0xA71);
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#isIndependentVowel(int)
   */
  protected boolean isIndependentVowel (int usv) {
    return (   0x0A05 <= usv && usv <= 0x0A14
            || 0x25cc == usv);
  }

  
  protected Position getPosition (int usv) {
    switch (usv) {
      case 0xA3F: return Position.left;
      
      case 0xA47:
      case 0xA48:
      case 0xA4B:
      case 0xA4C: return Position.topMatra;
      
      case 0xA01:
      case 0xA02:
      case 0xA70:
      case 0xA71: return Position.topOther;
      
      case 0xA41:
      case 0xA42: return Position.bottom;
          
      case 0xA3E:
      case 0xA40: return Position.rightMatra;
      
      case 0xA03: return Position.rightOther;
      
      default:    return Position.any; }
  }
  
  protected Shape rephLike (int usv) {
    return Shape.any;
  }

  protected boolean subjoins (int usv) {
    return usv == 0xA30 || usv == 0xA39 || usv == 0xA35;
  }
  
  protected boolean postjoins (int usv) {
    return usv == 0xA2F;
  }
  
  protected boolean postjoinsIndependentVowels (int usv) {
    return false;
  }
}