/*
 * File: LaoFormatter.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;

final class LaoFormatter extends GenericFormatter {
  
  //------------------------------------------------------------- firstPass ---
  
  /** Expand occurrences of SIGN AM into NIGGAHITA and SIGN AA.
   */
  protected int removeSignAm (AttributedRun run, int start, int limit) {
    // The only difficulty is that we want to place the NIGGAHITA in
    // front of any tone mark that may precede the SIGN AM. 
    // We have to do that because most fonts treat the NIGGAHITA 
    // and tone mark as "marks above" without further distinction,
    // and the NIGGAHITA of a SIGN AM must appear below those tone
    // marks.
    int cur = start;
    while (cur < limit) {
      int usv = run.elementAt (cur);
      if (usv == 0x0EB3 /* U+0EB3 LAO VOWEL SIGN AM */) {
        int prev = cur;
        while (   start <= prev - 1 
               && run.getElementStyle (prev-1, ElementAttribute.isGlyph) != Boolean.TRUE
               && 0x0EC8 <= run.elementAt (prev-1) /* U+0EC8 LAO TONE MAI EK */
               && run.elementAt (prev-1) <= 0xECB /* U+0ECB LAO TONE MAI CATAWA */) {
          prev--; }
        
        if (prev == cur) {
          // common case without tone marks
          run.replace (cur, new int[] {0x0ECD, 0x0EB2}); }
        
        else {
          int [] positions = new int [cur - prev + 1];
          for (int i = 0; i < positions.length; i++) {
            positions [i] = prev + i; }
          int [] elementIds = new int [cur - prev + 2];
          elementIds [0] = 0x0ECD;
          for (int i = 1; i < elementIds.length - 1; i++) {
            elementIds [i] = run.elementAt (prev + i - 1); }
          elementIds [elementIds.length - 1] = 0x0EB2;
          run.replace (positions, elementIds); }
 
        cur++;
        limit++; }
      
      cur++; }
    
    return limit;
  }

  public int firstPass (AttributedRun run, int start, int limit) {
    limit =  removeSignAm  (run, start, limit);
    return super.firstPass (run, start, limit);
  }
}
