/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.activitystreams;

import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

/**
 * Provides an abstraction of an activity stream. The stream is a collection of activities that usually belong to the
 * same underlying stream. The stream is bound to the jcr session requesting the stream and therefor subject to
 * access control.
 */
@ProviderType
public interface ActivityStream extends ActivityCollection {

    /**
     * Returns the ID of this activity stream. Usually its path.
     * @return the id of this stream.
     */
    String getId();

    /**
     * Checks if this is a default user stream.
     * @return <code>true</code> if this is the default user stream.
     *
     * @deprecated  since 0.0.8. use {@link #isDefaultStream()} instead.
     */
    @Deprecated
    boolean isDefaultUserStream();

    /**
     * Checks if this is a default stream.
     * @return <code>true</code> if this is the default stream.
     */
    boolean isDefaultStream();

    /**
     * Returns the resource that this stream is bound to.
     * @return the stream resource
     * @since 0.0.10
     */
    Resource getResource();

    /**
     * Returns the container that this stream belongs to.
     * @return the container resource.
     */
    Resource getContainerResource();

    /**
     * Returns the id of the stream container, which is the userId for user streams and the document path for topic
     * streams.
     * @return the container id or <code>null</code> if the container id cannot be determined
     * @since 0.0.12
     */
    String getContainerId();

    /**
     * Returns the name of the stream.
     * @return the name
     */
    String getName();

    /**
     * Returns the title of the stream.
     * @return the title
     * @since 0.0.16
     */
    String getTitle();

    /**
     * Deletes this activity stream and all it's activities.
     * @throws ActivityException
     */
    void delete() throws ActivityException;

    /**
     * Appends a new activity to this stream.
     *
     * @param activity the activity to write.
     * @return a new immutable activity object bound to this stream.
     * @throws ActivityException if an error occurs.
     */
    Activity append(Activity activity) throws ActivityException;

}