/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.activitystreams.utils;

import com.adobe.granite.activitystreams.ActivityStreamFilter;
import com.adobe.granite.activitystreams.AggregateOptions;

/**
 * <code>GenericAggregateOptions</code>
 * @since 0.0.10
 */
public class GenericAggregateOptions implements AggregateOptions {

    private ActivityStreamFilter filter = ActivityStreamFilter.ALL;

    private String[] types;

    /**
     * {@inheritDoc}
     */
    public ActivityStreamFilter getActivityStreamFilter() {
        return filter;
    }

    /**
     * Sets the stream filter
     * @param filter the filter
     * @return this aggregate options for chaining.
     */
    public GenericAggregateOptions setActivityStreamFilter(ActivityStreamFilter filter) {
        this.filter = filter;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    public String[] relationshipTypes() {
        return types;
    }

    /**
     * Sets the array of relationship types
     * @param types the types
     * @return this aggregate options for chaining.
     */
    public GenericAggregateOptions setRelationshipTypes(String[] types) {
        this.types = types;
        return this;
    }
}