/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.activitystreams.utils;

import com.adobe.granite.activitystreams.Activity;
import com.adobe.granite.activitystreams.ActivityObject;
import com.adobe.granite.activitystreams.MediaLink;
import com.adobe.granite.activitystreams.MutableActivity;
import com.adobe.granite.activitystreams.MutableActivityObject;
import com.adobe.granite.activitystreams.MutableMediaLink;

/**
 * <code>Util</code>...
 */
public class Util {

    public static MutableActivityObject copy(ActivityObject obj) {
        return obj == null ? null : obj.getMutableActivityObject();
    }

    public static MutableActivity copy(Activity obj) {
        return obj == null ? null : obj.getMutableActivity();
    }

    public static MutableMediaLink copy(MediaLink obj) {
        return obj == null ? null : obj.getMutableMediaLink();
    }

    // copied from cq-commons

    /** The list of characters that are valid label characters */
    public final static String[] STANDARD_LABEL_CHAR_MAPPING = new String[] {
            "_","_","_","_","_","_","_","_","_","_","_","_","_","_","_","_",
            "_","_","_","_","_","_","_","_","_","_","_","_","_","_","_","_",
            "_","_","_","_","_","_","_","_","_","_","_","_","_","-","_","_",
            "0","1","2","3","4","5","6","7","8","9","_","_","_","_","_","_",
            "_","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o",
            "p","q","r","s","t","u","v","w","x","y","z","_","_","_","_","_",
            "_","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o",
            "p","q","r","s","t","u","v","w","x","y","z","_","_","_","_","_",
            "_","f","_","_","_","fi","fi","_","_","_","_","_","_","_","_","_",
            "_","_","_","_","_","_","_","_","_","_","_","_","y","_","_","_",
            "_","i","c","p","o","v","_","s","_","_","_","_","_","_","_","_",
            "_","_","_","_","_","_","_","_","_","_","_","_","_","_","_","_",
            "a","a","a","a","ae","a","ae","c","e","e","e","e","i","i","i","i",
            "d","n","o","o","o","o","oe","x","o","u","u","u","ue","y","b","ss",
            "a","a","a","a","ae","a","ae","c","e","e","e","e","i","i","i","i",
            "o","n","o","o","o","o","oe","_","o","u","u","u","ue","y","b","y"
    };

    /**
     * Create a valid label out of an arbitrary string. Same as calling
     * {@link #createValidName(String, String[])} using
     * {@link #STANDARD_LABEL_CHAR_MAPPING}.
     *
     * @param title
     *            title to convert into a name
     * @return a valid label string
     */
    public static String createValidName(String title) {
        return createValidName(title, STANDARD_LABEL_CHAR_MAPPING);
    }

    /**
     * Create a valid label out of an arbitrary string with a custom character
     * mapping.
     *
     * @param title
     *            title to convert into a name
     * @param labelCharMapping
     *            a mapping of chars (index of the array) to strings that should
     *            be used as replacement for the characters
     * @return a valid label string
     */
    public static String createValidName(String title, String[] labelCharMapping) {
        char[] chrs=title.toCharArray();
        StringBuilder name = new StringBuilder(chrs.length);
        boolean prevEscaped = false;
        for (int idx=0; idx<title.length() && name.length()<64; idx++) {
            char c = title.charAt(idx);
            String repl = "_";
            if (c>=0 && c<labelCharMapping.length) {
                repl = labelCharMapping[c];
            }
            if ("_".equals(repl)) {
                // prevent escaping after a certain length
                if (!prevEscaped && name.length() < 16) {
                    name.append('_');
                }
                prevEscaped = true;
            } else {
                name.append(repl);
                prevEscaped = false;
            }
        }
        return name.toString();
    }

}