/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.asset.api;

import java.text.MessageFormat;

/**
 * Exception facade for all Asset related exceptions.
 * */
public class AssetException extends RuntimeException {

    private static final long serialVersionUID = -8254899862423644935L;

    private String messageFormat;
    java.lang.Object[] args;

	public AssetException(String message) {
        super(message);
    }

    /**
     * This constructor initializes class members
     * @param message Message string
     * @param params List of parameters to be incorporated in message string
     */
    public AssetException(String message , java.lang.Object... params){
        super();
        this.messageFormat = message;
        this.args= params;
    }

    /**
     * This constructor initializes class members
     * @param message Message string
     * @param rootCause rootCause of Exception
     * @param params List of parameters to be incorporated in message string
     */
    public AssetException(String message, Throwable rootCause, java.lang.Object... params){
        super(message,rootCause);
        this.messageFormat = message;
        this.args= params;
    }

    public AssetException(Throwable rootCause) {
        super(rootCause);
    }

    public AssetException(String message, Throwable rootCause) {
        super(message, rootCause);
    }

    /**
     * This method returns the message string which can be localized using i18n.
     * @return string
     */
    public String getMessageFormat(){
        return messageFormat;
    }

    public Object[] getArgs(){
        return args;
    }

    /**
     * This method overrides the default getMessage() method of Throwable class.
     * It returns formatted message string after incorporating the args list or detailMessage
     * @return string
     */
    @Override
    public String getMessage(){
        if(this.messageFormat!=null) {
            return MessageFormat.format(this.messageFormat, this.args);
        }
        return super.getMessage();
    }

}
