/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2017 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.auth.ims;

import java.util.Objects;

public final class IMSOrg {

    private final String orgName;
    private final OrgRef orgRef;

    public IMSOrg(String orgName, String ident, String authSrc) {
        this.orgName = orgName;
        this.orgRef = new OrgRef(ident, authSrc);
    }

    public String getOrgName() {
        return orgName;
    }

    public OrgRef getOrgRef() {
        return orgRef;
    }

    @Override
    public String toString() {
        return orgName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IMSOrg imsOrg = (IMSOrg) o;
        return Objects.equals(orgName, imsOrg.orgName) &&
                Objects.equals(orgRef, imsOrg.orgRef);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orgName, orgRef);
    }

    public static  class OrgRef {
        private final String ident;
        private final String authSrc;

        public OrgRef(String ident, String authSrc) {
            this.ident = ident;
            this.authSrc = authSrc;
        }

        public String getIdent() {
            return ident;
        }

        public String getAuthSrc() {
            return authSrc;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            OrgRef orgRef = (OrgRef) o;
            return Objects.equals(ident, orgRef.ident) &&
                    Objects.equals(authSrc, orgRef.authSrc);
        }
        @Override
        public int hashCode() {
            return Objects.hash(ident, authSrc);
        }
    }

}
