/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2020 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.oauth;

import org.osgi.annotation.versioning.ConsumerType;

import javax.servlet.http.HttpServletRequest;

/**
 * The <code>LogoutProvider</code> interface provides the ability to perform a log-out operation.
 * <p>
 * If a registered {@link Provider} service implements this interface the
 * {@link #logout(HttpServletRequest,ProviderConfig)} method is called during the dropCredentials
 * execution.
 *
 * @since 3.13
 */
@ConsumerType
public interface LogoutProvider {

    /**
     * This method will perform all the backend steps of the logout process.
     *
     * @param request The request to the logout URL. Used to correctly build the callback URL.
     * @param providerConfig The OAuth Provider configuration
     * @return the URL where to redirect after logout
     * 
     * @since 3.13
     */
    public String logout(HttpServletRequest request, ProviderConfig providerConfig);
}
