/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.oauth;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Expose the list of well known configuration properties so that external services can find and
 * use existing configurations for additional oauth functionality that is NOT related
 * to Authentication.
 */
@ProviderType
public final class ProviderConfigProperties {
    /**
     * When using {@link org.osgi.service.cm.ConfigurationAdmin} to create configs, use this factoryPid
     */
    public static final String FACTORY_PID = "com.adobe.granite.auth.oauth.provider";

    /**
     * A unique ID to identify this configuration id. This ID will be passed to the authentication handler as
     * a request parameter.
     */
    public static final String CONFIG_ID = "oauth.config.id";

    /**
     * The OAuth "Consumer Key"
     */
    public static final String CLIENT_ID = "oauth.client.id";

    /**
     * The OAuth "Consumer Secret"
     */
    public static final String CLIENT_SECRET = "oauth.client.secret";

    /**
     * OAuth "Scope" parameter
     */
    public static final String SCOPE = "oauth.scope";

    /**
     * The unique ID of the configured {@link Provider} implementation to use.
     */
    public static final String PROVIDER_ID = "oauth.config.provider.id";

    /**
     * Should JCR users be created if they do not exist?
     */
    public static final String AUTO_CREATE_USERS = "oauth.create.users";

    /**
     * Default value for AUTO_CREATE_USERS property is false
     */
    public static final boolean DEFAULT_AUTO_CREATE_USERS = false;

    /**
     * If new users are created, which groups should they be added to?
     */
    public static final String AUTO_CREATE_USERS_GROUPS = "oauth.create.users.groups";

    /**
     * Should user ID be encoded?
     */
    public static final String ENCODE_USER_IDS = "oauth.encode.userids";

    /**
     * Default value for ENCODE_USER_IDS property is false;
     */
    public static final boolean DEFAULT_ENCODE_USER_IDS = false;
    
    /**
     * Should user ID be hashed?
     */
    public static final String HASH_USER_IDS = "oauth.hash.userids";

    /**
     * Default value for HASH_USER_IDS property is false;
     */
    public static final boolean DEFAULT_HASH_USER_IDS = false;

    /**
     * The property to use as user ID when synchronizing users
     */
    public static final String USER_ID_PROPERTY = "oauth.userid.property";

    /**
     * The default behaviour is to use the user_id field
     */
    public static final String DEFAULT_USER_ID_PROPERTY = "";

    /**
     * Setting this to true will allow to have multiple users 
     * sharing the same oauthId 
     * 
     */
    public static final String FORCE_STRICT_USERNAME_MATCHING = "force.strict.username.matching";
    
    /**
     * Default value for FORCE_STRICT_USERNAME_MATCHING property is false;
     */
    public static final boolean DEFAULT_FORCE_STRICT_USERNAME_MATCHING = false;
    

    /**
     * URL configured with the OAuth providers to redirect the client back.
     * <p>Use a relative url to use the host of the original
     * request.</p>
     * <p>Leave empty to use the originally requested URL instead. Suffix
     * "/callback/j_security_check" is automatically appended to this url.</p>
     * Note: the domain for the callback must be \
     * registered at the provider side (e.g. Facebook or Twitter).
     */
    public static final String CALLBACK_URL = "oauth.callBackUrl";

    /**
     * Default value for CALLBACK_URL property is ""
     */
    public static final String DEFAULT_CALL_BACK_URL = "";

    /**
     * Should user's access token be stored in JCR with user profile?
     * If true, the system can use the access token to execute actions on behalf of the user later.
     */
    public static final String PERSIST_ACCESS_TOKEN = "oauth.access.token.persist";

    /**
     * Default value for PERSIST_ACCESS_TOKEN
     */
    public static final boolean DEFAULT_PERSIST_ACCESS_TOKEN = false;
    
    /**
     * Should user's access token be stored in the cookie?
     * If true, the system can use the access token to execute actions on behalf of the user later.
     */
    public static final String PERSIST_ACCESS_TOKEN_COOKIE = "oauth.access.token.persist.cookie";

    /**
     * Default value for PERSIST_ACCESS_TOKEN_COOKIE
     */
    public static final boolean DEFAULT_PERSIST_ACCESS_TOKEN_COOKIE = false;
    
    /**
     * Enable the Cross-Site Request Forgery state protection as 
     * per http://tools.ietf.org/html/draft-ietf-oauth-v2-31#section-10.12
     */
    public static final String ENABLE_CSRF_STATE_PROTECTION = "oauth.csrf.state.protection";

    /**
     * Default value for ENABLE_CSRF_STATE_PROTECTION
     */
    public static final boolean DEFAULT_ENABLE_CSRF_STATE_PROTECTION = true;

    /**
     * Should the request parameters be persisted in the callback url ?
     * This could be used to redirect the user to the original requested resource
     * **/
    public static final String PERSIST_REQUEST_PARAM_CALLBACK_URL = "oauth.redirect.request.params";


    /**
     * Default value for PERSIST_REQUEST_PARAM_CALLBACK_URL
     * **/
    public static final boolean DEFAULT_PERSIST_REQUEST_PARAM_CALLBACK_URL = false;

    public static final String ALLOW_SIBLING_CONFIGS = "oauth.config.siblings.allow";

    public static final boolean DEFAULT_ALLOW_SIBLING_CONFIGS = false;
}
