/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2021 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.auth.saml.spi;

/**
 * The saml interface identifies all top level saml requests and responses.
 * 
 * @author jasonhightower
 */
public interface Message {

	/**
	 * Gets the identifier for this message.
	 * @return String containing the identifier for this message.
	 */
	String getId();
	
	/**
	 * Sets the identifier for this message.
	 * @param id String containing the identifier for this message.
	 */
	void setId(final String id);

    /**
     * Store the message body
     * @param rawMessage The decoded, decrypted message as a String
     */
    void setRawMessage(final String rawMessage);

    /**
     * Get the message body
     * @return The decoded, decrypted message as a String
     */
    String getRawMessage();
}
