/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.confmgr;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.annotation.versioning.ProviderType;

/**
 * Service to lookup and access configurations in the repository.
 *
 * @deprecated Use of the open source
 *     <a href="https://sling.apache.org/documentation/bundles/context-aware-configuration/context-aware-configuration.html">
 *     Apache Sling Context-Aware Configuration API</a> is recommended for new code.
 *     The ConfMgr API is backed by the Sling CA implementation and will continue
 *     to be supported for existing code.
 */
@Deprecated
@ProviderType
public interface ConfMgr {

    /**
     * Retrieves a {@link Conf} for the given resource using the resource resolver
     * behind the given resource.
     *
     * @param resource a content resource for which a configuration should be resolved
     * @return a configuration (never null)
     */
    Conf getConf(Resource resource);

    /**
     * Retrieves a {@link Conf} for the given resource, but will make all lookups
     * on the configuration tree using the configResolver. Use this when a separate
     * user is needed for the configuration lookups.
     *
     * @param resource a content resource for which a configuration should be resolved
     * @param configResolver a dedicated resource resolver to be used for lookups
     *                       under the referenced configuration tree(s)
     * @return a configuration (never null)
     */
    Conf getConf(Resource resource, ResourceResolver configResolver);
}
