/*
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2019 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
package com.adobe.granite.contexthub.api;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;

public interface CodeService {

    /**
     * Returns generated output of kernel.js.
     * Output is built using {@link ContextHub#getKernelCode(SlingHttpServletRequest, SlingHttpServletResponse)} and
     * minimized if not set to debug.
     *
     * @param request request
     * @param response response
     * @return ContextHub's kernel JavaScript code
     */
    String getKernelCode(SlingHttpServletRequest request, SlingHttpServletResponse response);

    /**
     * Returns generated output of ui.js.
     * Output is built using {@link ContextHub#getUICode(SlingHttpServletRequest, SlingHttpServletResponse)} and
     * minimized if not set to debug
     *
     * @param request request
     * @param response response
     * @return output of ui.js
     */
    String getUICode(SlingHttpServletRequest request, SlingHttpServletResponse response);

    /**
     * Returns the ETag for kernel.js for the particular contexthub configuration.
     * The contexthub configuration, corresponding to whose kernel.js' the ETag should be returned, is retrieved from
     * the given request object.
     * @param request The request object from which the contexthub configuration path is retrieved
     * @return The ETag as {@code String}
     */
    String getKernelCodeETag(SlingHttpServletRequest request, SlingHttpServletResponse response);

    /**
     * Returns the ETag for ui.js for the particular contexthub configuration.
     * The contexthub configuration, corresponding to whose ui.js' the ETag should be returned, is retrieved from
     * the given request object.
     * @param request The request object from which the contexthub configuration path is retrieved
     * @return The ETag as {@code String}
     */
    String getUICodeETag(SlingHttpServletRequest request, SlingHttpServletResponse response);
}
