/*
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

package com.adobe.granite.contexthub.api;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.Set;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

import com.adobe.granite.contexthub.impl.ClientLib;
import com.adobe.granite.contexthub.impl.Constants;

public class Module {
    private boolean enabled;

    private String theme;

    private String name;

    private String resourceType;

    private ValueMap properties;

    private Resource resource;

    private String path;

    /* list of run modes in which given module should be initialized */
    private Set<String> runModes;

    /**
     * Constructs a module with properties from the given resource.
     *
     * @param resource the resource used to construct a module from
     */
    public Module(Resource resource) {
        this.resource = resource;
        path = resource.getPath();

        properties = ResourceUtil.getValueMap(resource);
        String[] runModesProperty = properties.get(Constants.MODULE_RUN_MODES, String[].class);

        enabled = properties.get(Constants.MODULE_ENABLED, false);
        name = properties.get(Constants.MODULE_TYPE, String.class);
        theme = properties.get(Constants.MODULE_THEME, String.class);
        resourceType = resource.getResourceType();
        runModes = new TreeSet<String>();

        if (runModesProperty != null) {
            runModes.addAll(Arrays.asList(runModesProperty));
        }
    }

    /**
     * Returns list of run modes in which module should be available.
     *
     * @return list of run modes
     */
    public Set<String> getRunModes() {
        return runModes;
    }

    /**
     * Whether this module should be enabled or not.
     *
     * @return {@code true} if this module should be enabled
     */
    public boolean isEnabled() {
        return enabled;
    }

    /**
     * Get the theme this module uses.
     *
     * @return the theme
     */
    public String getTheme() {
        return theme;
    }

    /**
     * Get the name of this module.
     *
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Get the resourceType of this module.
     *
     * @return the resourceType
     */
    public String getResourceType() {
        return resourceType;
    }

    /**
     * Get all properties of this module.
     *
     * @return the properties
     */
    public ValueMap getProperties() {
        return properties;
    }

    /**
     * Get the resource which describes this module.
     *
     * @return the resource
     */
    public Resource getResource() {
        return resource;
    }

    /**
     * Get the path where this module is defined.
     *
     * @return the path
     */
    public String getPath() {
        return path;
    }

    /**
     * Get the clientlib categories that should be included for this module.
     *
     * @return the clientlib categories
     */
    public List<String> getCategories() {
        List<String> clientLibs = new ArrayList<String>();

        clientLibs.add(ClientLib.buildClientlibName(Constants.CONTEXTHUB_CLIENTLIB_MODULE, getName()));
        clientLibs.add(ClientLib.buildClientlibName(Constants.CONTEXTHUB_CLIENTLIB_MODULE, getName(), Constants.CONTEXTHUB_CLIENTLIB_OVERRIDE_POSTFIX));

        /*
        // commenting out until themes are really in use - not they are not supported
        clientLibs.add(ClientLib.buildClientlibName(Constants.CONTEXTHUB_CLIENTLIB_MODULE, getName(), getTheme()));
        clientLibs.add(ClientLib.buildClientlibName(Constants.CONTEXTHUB_CLIENTLIB_MODULE, getName(), getTheme(),
                Constants.CONTEXTHUB_CLIENTLIB_OVERRIDE_POSTFIX));
        */

        return clientLibs;
    }
}
