/*
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2018 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
package com.adobe.granite.contexthub.models;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Defines the {@code ContextHubConfigField} Sling Model used for the {@code /granite/contexthub/components/configuratino/form/inheritedconfig} component.
 *
 */
@ProviderType
public interface ContextHubConfigField {

    /**
     * Indicates if the configuration is inherited from a parent resource.
     * @return
     */
    boolean isInheritedFromParent();

    /**
     * Returns the path where the inherited configuration can be found, or {@code null} when the configuration isn't inherited.
     * @return
     */
    String getInheritedConfigPath();
    
}
