/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.haf.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Registers an action with the API framework. This is then surfaced to callers. The list of parameters to the method
 * is converted into HTTP style parameters.  This is only processed if the Class also has an ApiModel annotation.
 * An action method can return either void (and use default response settings) or an ApiResponse instance to provide
 * custom data to be used in the response.
 * @see ApiModel
 * TODO: List parameter mappings add more parameters
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ApiAction {
    /**
     * The HTTP Method to bind this action to.
     * @return HTTP Method to Bind to
     */
    public String method() default "POST";

    /**
     * A name for this action, which will be generated from the method name. For POST or PUT methods this will be
     * passed as an ":operation" parameter like Sling operations. This parameter will be stripped before invoking the
     * target action.
     * @return name of the Action
     */
    public String name() default "";

    /**
     * Title of the Action, this is used in the Siren serialization and likely later surfaced as documentation.
     * @return the title of the Action
     */
    public String title() default "";

    /**
     * The Content Type expected for the HTTP Request that triggers the action.
     * @return The content type of the request
     */
    public String type() default "";

    /**
     * Specifies that this action is the default action for the specified HTTP method.  When a request comes in to
     * the resource and the framework cannot match an exact action for it it will be passed into this action.  Only
     * one default action is allowed per HTTP method, and none are required to be registered.  Default actions are
     * not serialized into the outputted JSON on a get.
     * @return Whether or not this is the default action for the specified HTTP method
     */
    public boolean isDefault() default false;

    /**
     * Allows specifying an alternate resource path to be used when constructing the HREF for the action.  By default,
     * the path of the current resource is used.  This can be used to reference actions that are available at a
     * specific URL instead of being available from the current resource.
     * @return The resource path to use when constructing the HREF.
     */
    public String resourcePath() default "";
}
