/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.adobe.granite.haf.api.ModelLookup;
import com.adobe.granite.haf.apimodel.impl.NullModelLookup;

/**
 * Registers a model with the Api Framework. This is the starting point for further processing. This binds either a sling:resourceType
 * or some programmatically mapped Pojo to a resource in Sling.
 *
 * @see ModelLookup
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ApiModel {
    /**
     * The sling:resourcetype to bind this Model to. This does not use isA to determine hierarchy for now it only
     * matches on the string value.
     * @return the resource type to bind to
     */
    public String resourceType() default "";

    /**
     * The category this API belongs to is the first token in the URL after the api root. This allows different Pojos
     * to represent the same resource types differently based on context.
     * @return the category this belongs in
     */
    public String category();

    /**
     * Returns a list of classes that will be used when Siren serializes this Pojo to JS.
     * @return array of strings for the class of this object
     */
    public String[] type() default {"default"};

    /**
     * If a Pojo can't be simply bound to a sling resource type or no resource types exist for the resource then pass
     * this lookup class back and programmatically return the Pojos to use.
     * @return class that will manage the lookups for this model
     */
    public Class<? extends ModelLookup> modelLookup() default NullModelLookup.class;

    /**
     * The default media type to use to find a HypermediaConverter to serialize the model.  This will be used if the
     * accepts header in the request doesn't request a specific media type that can be satisfied by one of the
     * registered converters in the system.
     * @return The media type used to look up the HypermediaConverter to use as a default.
     */
    public String defaultConverterMediaType() default "";

    /**
     * Mark this as the default model for the category. If no model is found in the resource type registration or in
     * the model lookup calls a model with this attribute set to true will be used. Only one default model is allowed
     * per category.
     * @return if the model is the default
     */
    public boolean isDefault() default false;

    /**
     * Use this to signal to the framework to managed this object via a different interface. This is especially useful
     * if this model also uses SlingModels. This value should track one of the adapters registrations.
     * @return the model class
     */
    public Class<?> modelClass() default Object.class;
}
