/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.haf.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation marks a model as synthetic.  Meaning it is able to model a synthetic resource which does not
 * correspond to a node that exists in the repository.
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ApiSyntheticModel {
    /**
     * A list of parent models that can "own" this synthetic model. These can themselves also be synthetic models.
     * @return a list of classes that point the implementation of the parent model.
     */
    public Class<?>[] parentmodel();

    /**
     * The path segment used to locate this synthetic model. This string can be a regular expression to allow
     * flexibility in registering many synthetic models under a parent model.
     * @return a string which will be used as a regular expression to match the path segment. If the value is empty it
     *         will match all segments.
     */
    public String segmentPattern() default "";
}
