/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.haf.api;

import java.util.Map;

import javax.annotation.CheckForNull;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.post.Modification;
import org.osgi.annotation.versioning.ProviderType;

/**
 * An interface for providing the framework with custom values to be used in the response.  An instance of ApiResponse
 * is read only.  To create an ApiResponse use ApiResponseBuilder.
 */
@ProviderType
public interface ApiResponse {
    /**
     * Get the HTTP status code to be used in the response.
     * @return The HTTP status code
     */
    @CheckForNull Integer getStatusCode();

    /**
     * Get the HTTP status message to be used in the response.
     * @return The HTTP status message
     */
    @CheckForNull String getStatusMessage();

    /**
     * Get the HTTP headers to be added to the response.
     * @return The HTTP headers
     */
    @CheckForNull Map<String, String[]> getHeaders();

    /**
     * Get the entity to be used as the body in the response.  The entity must be a Resource that can be understood
     * by the HTTP API framework.
     * @return The entity Resouce to be used as the response body.
     */
    @CheckForNull Resource getEntity();

    /**
     * Get the body to returned in the response.  This allows free-form response bodies, beyond the resource covered
     * by getEntity.  This method is mutually exclusive to getEntity and if this method return non-null it will be used
     * in the response and getEntity will be ignored.
     * @return An instance of CharSequence or a byte[] to be used as the response body
     */
    @CheckForNull Object getBody();

    /**
     * Get the content type of the body returned by this ApiResponse.  This method is only used when returning a free
     * form body using the getBody() method.
     * @return The content type of the body
     */
    @CheckForNull String getContentType();

    @CheckForNull Iterable<Modification> getChanges();
}
