/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.api;

import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

/**
 * If the models that are being exposed do not have resource types or they have a more complex realationship than
 * simply the type this object can be used to programmatically map the resource to a class available in the bundle.
 */
@ProviderType
public interface ModelLookup {
    /**
     * Maps a resource to class
     * @param resource the resource that needs mapping
     * @return the class to use to represent the resource
     */
    public Class<?> getModel(Resource resource);
}
