/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.api;

import aQute.bnd.annotation.ProviderType;

/**
 * An interface providing the ordering details for paginated requests.  Ordering consists of a field to order by,
 * as well as the direction to ordering should be applied.
 */
@ProviderType
public interface OrderByDetails {

    /**
     * The name of the field the results should be ordered on.
     * @return The field name.
     */
    String getField();

    /**
     * The direction the ordering should be applied.
     * @return The direction.
     */
    SortOrder getSortOrder();
}
