/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.converter.api;

import org.osgi.annotation.versioning.ProviderType;

import java.util.Map;

import javax.annotation.CheckForNull;

/**
 * An object describing the response from a HypermediaConverter serializing a resource.
 */
@ProviderType
public interface ConverterResponse {
    /**
     * Get the headers of the response.
     * @return A map of headers.
     */
    @CheckForNull
    Map<String, String[]> getHeaders();

    /**
     * Get the content type of the response.
     * @return The content type.
     */
    @CheckForNull
    String getContentType();

    /**
     * Get the body of the response.
     * @return The body.
     */
    @CheckForNull
    Object getBody();
}
