/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.converter.api;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

import com.adobe.granite.haf.converter.api.description.ModelDescription;
import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

/**
 * Interface for a hypermedia converter that can render a Resource into a particular hypermedia type.
 */
@ProviderType
public interface HypermediaConverter {

    String MEDIA_TYPE_SIREN = "application/vnd.siren+json";
    String MEDIA_TYPE_ADOBE_DIRECTORY = "application/vnd.adobecloud.directory+json";
    String MEDIA_TYPE_ADOBE_ASSETS = "adobe/asset";
    String MEDIA_TYPE_ADOBE_RENDITION = "adobe/rendition";
    String MEDIA_TYPE_ADOBE_METADATA = "adobe/metadata";
    String MEDIA_TYPE_ADOBE_VERSIONS = "application/vnd.adobe.versions+json";

    /**
     * Return the media type string this converter supports
     * @return The media type this converter supports
     */
    @Nonnull
    String getMediaTypeMatcher();

    /**
     * Serialize the resource into the media type specific representation
     * @param context The ConverterContext
     * @param resource The Resource to render
     * @param description The ModelDescription describing the resource to be serialized
     * @return The media type specific representation of the resource.
     */
    @CheckForNull
    ConverterResponse render(ConverterContext context, Resource resource, ModelDescription description);

    /**
     * Serialize a resource to be embedded into the main resource serialization as a child. The Object returned must
     * be a JSONObject, JSONArray, or instance of CharSequence
     * @param context The ConverterContext
     * @param resource The Resource to render
     * @param description The ModelDescription describing the resource to be serialized
     * @return A JSONObject, JSONArray, or CharSequence serialization of the resource
     */
    @CheckForNull
    Object renderSubEntity(ConverterContext context, Resource resource, ModelDescription description);
}
