/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.converter.api.description;

import org.osgi.annotation.versioning.ProviderType;

import com.adobe.granite.haf.annotations.ApiProperty;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/**
 * A description of a property defined in the model.
 */
@ProviderType
public interface PropertyDescription {
    /**
     * Get the name of the property.
     * @return The name of the property.
     */
    @Nonnull
    String getName();

    /**
     * Get the value of the property.
     * @return The property value.
     */
    @CheckForNull
    Object getValue();

    /**
     * The scope of the property.  The scope can be used to decide when to serialize the property.  Whether it is
     * serialized for a main entity, a child entity or both.
     * @return The property's scope.
     */
    @Nonnull
    ApiProperty.SCOPE getScope();
}
