/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package com.adobe.granite.keystore;

/**
 * The {@code KeyStoreNotInitialisedException} is thrown by the methods from the {@link com.adobe.granite.keystore.KeyStoreService} that
 * access a key store / trust store before the store is actually initialised.
 */
public class KeyStoreNotInitialisedException extends RuntimeException {

    public KeyStoreNotInitialisedException(String message) {
        super(message);
    }

    public KeyStoreNotInitialisedException(String message, Throwable cause) {
        super(message, cause);
    }

    public KeyStoreNotInitialisedException(Throwable cause) {
        super(cause);
    }
}
