/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.logging;

import java.util.List;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The log analyzer is a service making log entries available based on a configuration.
 * By default all log messages with log level ERROR are recorded.
 *
 * Additional configurations can be provided through the {@link #setLogConfiguration(LogConfigurationEntry[])}
 * method. However, this configuration is not persisted and does not survive a
 * restart.
 */
@ProviderType
public interface LogAnalyser {

    /**
     * Get the current log configuration
     * @return An array of configurations. The array might have the length zero.
     */
    LogConfigurationEntry[] getLogConfiguration();

    /**
     * Set the new configurations
     * @param config An array of configurations or <code>null</code> to remove all configs.
     */
    void setLogConfiguration(LogConfigurationEntry[] config);

    /**
     * Get the last number of log entries.
     * @param size The maximum number of log entries or <code>-1</code> to get all available entries.
     * @return A list of log entries
     */
    List<LogEntry> getLastLogEntries(int size);
}
