/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.operations;

import org.apache.sling.api.resource.ValueMap;
import org.osgi.annotation.versioning.ProviderType;


/**
 * General service for managing all kind of operations related tasks
 */
@ProviderType
public interface OperationsService {

    /** Property setting a condition for the run mode. */
    String CONDITION_RUNMODE = "granite.operations.condition.runmode";

    /** Property setting a condition for an mbean. */
    String CONDITION_MBEAN = "granite.operations.condition.mbean";

    /** Property setting a condition for an mbean attribute. */
    String CONDITION_MBEAN_ATTRIBUTE = "granite.operations.condition.mbean.attribute";

    /**
     * Checks whether the provided object is currently enabled.
     * @param properties The properties of that object
     *
     * The check whether the object is enabled might check different
     * properties, e.g. the {@link OperationsService#CONDITION_RUNMODE}
     * property.
     *
     * @return <code>true</code> if enabled.
     */
    boolean isEnabled(ValueMap properties);
}
