/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.references;

import java.util.Set;

import org.apache.sling.api.resource.Resource;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The <code>ReferenceAggregator</code> is an OSGi-service providing creation of {@link Reference}s
 * for the given resource.
 * The service can be obtained from the OSGi service registry via the interface.
 *
 * @since 1.0
 */
@ProviderType
public interface ReferenceAggregator {

    /**
     * Create a {@link ReferenceList} for the given <code>resource</code>.
     *
     * @param resource The {@link Resource} for which to create a {@link ReferenceList}.
     * @return The {@link ReferenceList}.
     */
    ReferenceList createReferenceList(Resource resource);

    /**
     * Create a {@link ReferenceList} for the given <code>resource</code>.
     *
     * @param resource The {@link Resource} for which to create a {@link ReferenceList}.
     * @param types An array of {@link String}s corresponding to references types to consider.
     * @return The {@link ReferenceList}.
     */
    ReferenceList createReferenceList(Resource resource, String... types);

    /**
     * Returns a set of all known references types. The types are provided by the registered {@link ReferenceProvider}s.
     *
     * @return A {@link Set} of references types and their keys (names) - or an empty set if no providers are
     *         registered.
     */
    Set<String> getTypes();

}
