/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.resourcestatus;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Map;

/**
 * <p>Represents status information about a {@link org.apache.sling.api.resource.Resource}. A
 * {@code ResourceStatus} is defined by a type, a priority, a data map containing the status
 * information and other data needed to render the status, and possibly a resource (super) type.
 * </p>
 *
 * <p>Consuming status components retrieve {@link org.apache.sling.api.resource.Resource}s
 * wrapping a {@code ResourceStatus} (see {@link com.adobe.granite.resourcestatus}). These
 * resources contain the status data as their properties, and can be rendered using the defined
 * resource (super) type.</p>
 */
public interface ResourceStatus {

    /**
     * Returns the type of this status defining the module or feature this status is associated
     * with.
     *
     * @return the status type
     * @see ResourceStatusProvider#getType()
     */
    @Nonnull
    String getType();

    /**
     * Returns the priority of this status corresponding to its importance
     * ({@code Integer.MAX_VALUE} being the highest priority).
     *
     * @return the status priority
     */
    int getPriority();

    /**
     * Returns an unmodifiable map containing the status information and data needed to render this
     * status.
     *
     * @return a map containing key/value pairs
     */
    @Nullable
    Map<String, Object> getData();

    /**
     * Returns the resource type to render this status.
     *
     * @return a resource type or {@code null}
     */
    @Nullable
    String getResourceType();

    /**
     * Returns the resource super type to render this status.
     *
     * @return a resource super type or {@code null}
     */
    @Nullable
    String getResourceSuperType();

}
