/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

/**
 * <p>This package defines an API which models generic statuses about resources and provides a
 * mechanism to generate and retrieve such statuses. Resource statuses are meant to be displayed in
 * the user interface by a status component which retrieves and renders statuses about a resource.
 * </p>
 *
 * <p>In order to provide statuses about resources, modules implement the
 * {@link com.adobe.granite.resourcestatus.ResourceStatusProvider} interface. A
 * {@link com.adobe.granite.resourcestatus.ResourceStatusProvider} generates
 * {@link com.adobe.granite.resourcestatus.ResourceStatus}es of a certain status type.</p>
 *
 * <p>Statuses are provided to consumers via the Sling {@code ResourceProvider} API. A status
 * component uses a {@code ResourceResolver} to retrieve statuses about a certain resource. By
 * using a special resource path format, it can retrieve all statuses, or only those matching one
 * or several status types (see
 * {@link com.adobe.granite.resourcestatus.impl.StatusResourceProviderImpl}). The statuses are
 * obtained as {@link org.apache.sling.api.resource.Resource} objects wrapping statuses (see
 * {@link com.adobe.granite.resourcestatus.ResourceStatus}). Using the default Sling JSON servlet,
 * status components can also retrieve a JSON representation of the statuses.</p>
 */
@Version("1.0.0")
package com.adobe.granite.resourcestatus;

import aQute.bnd.annotation.Version;
