/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.granite.rest.filter;

import org.osgi.annotation.versioning.ConsumerType;

/**
 * The {@code Filter} is a service interface which is used for filtering a
 * {@link Resource element}.
 */
@ConsumerType
public interface Filter<Resource> {

    /**
     * Determines whether elements should be filtered or not.
     * 
     * @param element The element to be matched against the filter
     * @return {@code true} if the element matches the filter, otherwise
     *         {@code false}
     */
    boolean matches(Resource element);

}
