/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.rest.filter;

import org.apache.sling.api.resource.Resource;

import org.osgi.annotation.versioning.ConsumerType;

/**
 * The {@code FilterFactory} defines the service interface to get and create
 * {@code Filter}'s dynamically on a per usage base.
 * <p>
 * Implementations of this interface must be defined as OSGi services and define
 * a service property {@link FilterFactory#NAME} which is used to select the
 * FilterFactory when a request parameter with the name {@code filter.<name>} is
 * provided with the request.
 */
@ConsumerType
public interface FilterFactory {

    /**
     * The name of the service registration property containing the name this
     * this FilterFactory is registered with (value is "filterfactory.name").
     */
    String NAME = "filterfactory.name";

    /**
     * Returns a {@link Filter} instance which may be initialized with the
     * specified {@code value}.
     * 
     * @param value Filter value
     * @return Filter instance
     */
    Filter<Resource> getFilter(String value);

}
