/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.security.user;

/**
 * Enumeration of combinations of authorizable types.
 */
public enum AuthorizableTypes {
    /**
     * All authorizables: users (and system users) and groups.
     */
    ALL(true, true, true),

    /**
     * Only users. System users are excluded.
     */
    USERS(true, false, false),

    /**
     * Only system users. Regular users are excluded.
     */
    SYSTEM_USERS(false, true, true),

    /**
     * All users (including system users).
     */
    USERS_AND_SYSTEM_USERS(true, true, false),

    /**
     * Only groups.
     */
    GROUPS(false, false, true);

    /*
     The remaining two combinations: GROUPS_AND_USERS and GROUPS_AND_SYSTEM_USERS are intentionally left out.
     They can be added when there is an actual use case for those combinations.
     */


    private final boolean users;
    private final boolean systemUsers;
    private final boolean groups;

    private AuthorizableTypes(boolean users, boolean systemUsers, boolean groups) {
        this.users = users;
        this.systemUsers = systemUsers;
        this.groups = groups;
    }

    /**
     * Provides a way to determine if this AuthorizableTypes value refers to users as well.
     * Only regular users (not system users) are reflected by this method.
     * @return {@code true} if the regular users are included by this enum value and {@code false} otherwise
     */
    public boolean includesUsers() {
        return users;
    }

    /**
     * Provides a way to determine if this AuthorizableTypes value refers to system users as well.
     * Only system users (not regular users) are reflected by this method.
     * @return {@code true} if the system users are included by this enum value and {@code false} otherwise
     */
    public boolean includesSystemUsers() {
        return systemUsers;
    }

    /**
     * Provides a way to determine if this AuthorizableTypes value refers to groups as well.
     * @return {@code true} if the groups are included by this enum value and {@code false} otherwise
     */
    public boolean includesGroups() {
        return groups;
    }
}
