/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.security.user.util;

import java.util.Date;
import java.util.Map;

/**
 * ImpersonationNotifier...
 */
public interface ImpersonationNotifier {

    /**
     * Notify the implementation about an user impersonating another user or
     * reverting the impersonation back.
     *
     * @param date The date of the action.
     * @param userId The ID of the user being target of the request.
     * @param action The impersonation operation that was executed. The value
     * may be either "sudo" or "revert" reflecting the two actions related to
     * impersonation.
     * @param props The properties related to the operation. The map is empty
     * if the action is "revert" and a single-valued map indicating who will
     * be impersonated (key: "sudo", the value being the id of the user
     * to impersonate as).
     */
    void notify(Date date, String userId, String action, Map<String, Object> props);

}
