/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.ui.clientlibs.script;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;

import javax.annotation.Nonnull;

import org.osgi.annotation.versioning.ConsumerType;

import com.adobe.granite.ui.clientlibs.LibraryType;

/**
 * {@code ScriptProcessor} processes a script by minifying, obfuscating etc.
 */
@ConsumerType
public interface ScriptProcessor {

    /**
     * Name of the minify feature.
     */
    String FEATURE_MINIFY = "minify";

    /**
     * Name of this processor.
     * @return the name
     */
    @Nonnull
    String getName();

    /**
     * Checks if this processor can handle the give library type. handles the file with the given extension
     * @param type the type
     * @return {@code true} if this processor handles the type
     */
    boolean handles(@Nonnull LibraryType type);

    /**
     * Processes the given input using the options.
     * @param type the library type to process
     * @param source input source
     * @param output output writer
     * @param options processing options.
     * @return {@code true} if the sources were processed
     * @throws IOException if an I/O error occurs
     */
    boolean process(@Nonnull LibraryType type, @Nonnull ScriptResource source, @Nonnull Writer output, @Nonnull Map<String, String> options)
            throws IOException;
}