/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
* Copyright 2012 Adobe
* All Rights Reserved.
*
* NOTICE: All information contained herein is, and remains
* the property of Adobe and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe
* and its suppliers and are protected by all applicable intellectual
* property laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe.
**************************************************************************/
package com.adobe.granite.ui.components;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.http.Cookie;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

/**
 * A class to receive the client state for DOM attributes out of Coral UI's
 * {@code util.state}. It's purpose is to receive the values from the HTTP
 * request and either transform it to a JSON object or to add them to an
 * existing {@link AttrBuilder}.
 *
 * @deprecated CoralUI v1 specific
 */
@Deprecated
public class ClientState {

    private final String COOKIE_NAME = "cui-state";

    @Nonnull
    private final String STATE_GLOBAL_NAMESPACE = "global";

    private JSONObject json;

    public ClientState(@Nonnull SlingHttpServletRequest slingRequest) {
        Cookie cookie = slingRequest.getCookie(COOKIE_NAME);

        if (cookie == null) {
            return;
        }

        try {
            String cookieVal = URLDecoder.decode(cookie.getValue(), "UTF-8");
            json = new JSONObject(cookieVal);
        } catch (JSONException ex) {
            json = null;
        } catch (UnsupportedEncodingException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    private void addAttribute(@Nonnull AttrBuilder attr, @Nonnull String attribute, @Nonnull JSONObject attributeJson)
            throws JSONException {
        if ("class".equals(attribute)) {
            for (String anAttrClassList : attributeJson.optString("val").split("\\s+")) {
                attr.addClass(anAttrClassList);
            }
        } else if ("rel".equals(attribute)) {
            attr.addRel(attributeJson.optString("val", null));
        } else if ("href".equals(attribute)) {
            attr.addHref(attribute, attributeJson.optString("val", null));
        } else if (attribute.matches("^data-.+")) {
            attr.add(attribute, attributeJson.optString("val", null));
        } else if (attributeJson.optBoolean("val")) {
            attr.addBoolean(attribute, true);
        } else {
            attr.add(attribute, attributeJson.optString("val", null));
        }
    }

    /**
     * Returns all attributes from the global namespace for the given selector.
     *
     * @param selector
     *            the selector
     * @return all attributes from the global namespace for the given selector
     */
    @CheckForNull
    public JSONObject getState(@Nonnull String selector) {
        return getState(selector, STATE_GLOBAL_NAMESPACE);
    }

    /**
     * Returns all attributes from a given namespace for the given selector.
     *
     * @param selector
     *            the selector
     * @param namespace
     *            the namespace
     * @return all attributes from the given namespace for the given selector
     */
    @CheckForNull
    public JSONObject getState(@Nonnull String selector, @Nonnull String namespace) {
        return getState(selector, null, namespace);
    }

    /**
     * Returns all attributes which keys are included in the attributes array from
     * the global namespace for the given selector.
     *
     * @param selector
     *            the selector
     * @param attributes
     *            the keys of the attributes we are interested in
     * @return all attributes which keys are included in the attributes array from
     *         the global namespace for the given selector
     */
    @CheckForNull
    public JSONObject getState(@Nonnull String selector, @CheckForNull String[] attributes) {
        return getState(selector, attributes, STATE_GLOBAL_NAMESPACE);
    }

    /**
     * Returns all attributes which keys are included in the attributes array from a
     * given namespace for the given selector.
     *
     * @param selector
     *            the selector
     * @param attributes
     *            the keys of the attributes we are interested in
     * @param namespace
     *            the namespace
     * @return all attributes which keys are included in the attributes array from a
     *         given namespace for the given selector
     */
    @CheckForNull
    public JSONObject getState(@Nonnull String selector, @CheckForNull String[] attributes, @Nonnull String namespace) {
        JSONObject selectorJson;

        try {
            JSONObject namespaceJson = json.getJSONObject(namespace);
            selectorJson = namespaceJson.getJSONObject(selector);
        } catch (Exception e) {
            return null;
        }

        if (selectorJson == null || attributes == null) {
            return selectorJson;
        }

        List<String> attrList = Arrays.asList(attributes);

        for (Iterator<String> keys = selectorJson.keys(); keys.hasNext();) {
            String attribute = keys.next();

            if (!attrList.contains(attribute)) {
                selectorJson.remove(attribute);
            }
        }

        return selectorJson;
    }

    /**
     * Adds all attributes from the global namespace for the given selector to an
     * AttrBuilder.
     *
     * @param attr
     *            the attribute builder
     * @param selector
     *            the selector
     * @return {@code true} if the addition is successful, {@code false} otherwise
     */
    public boolean restoreState(@Nonnull AttrBuilder attr, @Nonnull String selector) {
        return restoreState(attr, selector, STATE_GLOBAL_NAMESPACE);
    }

    /**
     * Adds all attributes from a given namespace for the given selector to an
     * AttrBuilder.
     *
     * @param attr
     *            the attribute builder
     * @param selector
     *            the selector
     * @param namespace
     *            the namespace
     * @return {@code true} if the addition is successful, {@code false} otherwise
     */
    public boolean restoreState(@Nonnull AttrBuilder attr, @Nonnull String selector, @Nonnull String namespace) {
        return restoreState(attr, selector, null, namespace);
    }

    /**
     * Adds all attributes which keys are included in the attributes array from the
     * global namespace for the given selector to an AttrBuilder.
     *
     * @param attr
     *            the attribute builder
     * @param selector
     *            the selector
     * @param attributes
     *            the attributes
     * @return {@code true} if the addition is successful, {@code false} otherwise
     */
    public boolean restoreState(@Nonnull AttrBuilder attr, @Nonnull String selector,
            @CheckForNull String[] attributes) {
        return restoreState(attr, selector, attributes, STATE_GLOBAL_NAMESPACE);
    }

    /**
     * Adds all attributes which keys are included in the attributes array from a
     * given namespace for the given selector to an AttrBuilder.
     *
     * @param attr
     *            the attribute builder
     * @param selector
     *            the selector
     * @param attributes
     *            the attributes
     * @param namespace
     *            the namespace
     * @return {@code true} if the addition is successful, {@code false} otherwise
     */
    @SuppressWarnings("null")
    public boolean restoreState(@Nonnull AttrBuilder attr, @Nonnull String selector, @CheckForNull String[] attributes,
            @Nonnull String namespace) {
        try {
            JSONObject selectorJson = getState(selector, attributes, namespace);
            if (selectorJson == null) {
                return false;
            }
            for (Iterator<String> keys = selectorJson.keys(); keys.hasNext();) {
                String attribute = keys.next();
                JSONObject attributeJson = selectorJson.getJSONObject(attribute);
                addAttribute(attr, attribute, attributeJson);
            }

            return true;
        } catch (JSONException e) {
            return false;
        }
    }
}
