/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.ui.components;

import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.Nonnull;

/**
 * Denotes a specific value fetching strategy for BulkEditValueMap
 */
@ProviderType
public interface ValueFetchStrategy {

    /***
     *
     * @param key The property name to fetch
     * @param resource The resource which property value is fetched
     * @return The result of fetch conversion
     */
    Object apply(@Nonnull String key, @Nonnull Resource resource);
}
