/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
* Copyright 2013 Adobe
* All Rights Reserved.
*
* NOTICE: All information contained herein is, and remains
* the property of Adobe and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe
* and its suppliers and are protected by all applicable intellectual
* property laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe.
**************************************************************************/
package com.adobe.granite.ui.components.ds;

import java.util.Iterator;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ConsumerType;

/**
 * DataSource is an abstract collection of {@link Resource}.
 */
@ConsumerType
public interface DataSource {

    /**
     * Returns the data.
     *
     * @return The iterator of the data.
     */
    @Nonnull
    Iterator<Resource> iterator();

    /**
     * Returns the offset of this datasource.
     *
     * It returns {@code null} by default.
     *
     * @return The offset of the datasource, or {@code null} when the offset is
     *         unknown or not set.
     */
    @CheckForNull
    default Long getOffset() {
        return null;
    }

    /**
     * Returns the limit of this datasource.
     *
     * It returns {@code null} by default.
     *
     * @return The limit of the datasource, or {@code null} when the offset is
     *         unknown or not set.
     */
    @CheckForNull
    default Long getLimit() {
        return null;
    }

    /**
     * Returns the total count or the total as far as it is known.
     *
     * It returns {@code null} by default.
     *
     * @return The total count, or {@code null} if it is not known.
     */
    @CheckForNull
    default Long getGuessTotal() {
        return null;
    }
}
