/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
* Copyright 2013 Adobe
* All Rights Reserved.
*
* NOTICE: All information contained herein is, and remains
* the property of Adobe and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe
* and its suppliers and are protected by all applicable intellectual
* property laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe.
**************************************************************************/
package com.adobe.granite.ui.components.ds;

import java.util.Iterator;

import javax.annotation.Nonnull;

import org.apache.commons.collections4.iterators.ListIteratorWrapper;
import org.apache.sling.api.resource.Resource;

/**
 * A datasource that simply takes the passed resource iterator as its data.
 */
public class SimpleDataSource extends AbstractDataSource {
    @Nonnull
    private final ListIteratorWrapper<Resource> wrapper;

    public SimpleDataSource(@Nonnull Iterator<Resource> iterator) {
        this.wrapper = new ListIteratorWrapper<>(iterator);
    }

    @Override
    @Nonnull
    public Iterator<Resource> iterator() {
        wrapper.reset();
        return wrapper;
    }
}
