/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
* Copyright 2014 Adobe
* All Rights Reserved.
*
* NOTICE: All information contained herein is, and remains
* the property of Adobe and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe
* and its suppliers and are protected by all applicable intellectual
* property laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe.
**************************************************************************/
package com.adobe.granite.ui.components.rendercondition;

import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import javax.servlet.ServletException;

/**
 * A condition that decides based on
 * {@link AccessControlManager#hasPrivileges(String, Privilege[])}.
 */
public class PrivilegeRenderCondition implements RenderCondition {
    @Nonnull
    private AccessControlManager acm;

    @Nonnull
    private String path;

    @Nonnull
    private Privilege[] privileges;

    public PrivilegeRenderCondition(@Nonnull AccessControlManager acm, @Nonnull String path,
            @Nonnull String[] privilegeNames) throws RepositoryException {
        this.acm = acm;
        this.path = path;
        this.privileges = converts(privilegeNames);
    }

    public PrivilegeRenderCondition(@Nonnull AccessControlManager acm, @Nonnull String path,
            @Nonnull Privilege[] privileges) {
        this.acm = acm;
        this.path = path;
        this.privileges = privileges;
    }

    @Nonnull
    private Privilege[] converts(@Nonnull String[] privilegeNames) throws RepositoryException {
        Privilege[] privileges = new Privilege[privilegeNames.length];

        for (int i = 0; i < privilegeNames.length; i++) {
            privileges[i] = acm.privilegeFromName(privilegeNames[i]);
        }

        return privileges;
    }

    @Override
    public boolean check() throws ServletException {
        try {
            return acm.hasPrivileges(path, privileges);
        } catch (RepositoryException e) {
            return false;
        }
    }
}
