/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow;

//TODO Define more fine grained exception model.

/**
 * <code>WorkflowException</code> is the base class for all workflow related
 * exceptions that can occur during execution of workflows and according
 * activities.
 */
public class WorkflowException extends Exception {
	/**
	 * Generated serial version UID.
	 */
	private static final long serialVersionUID = 3126765556125618406L;

	/**
	 * Constructs a new <code>WorkflowException</code> with the specified
	 * detail message. The cause is not initialized, and may subsequently be
	 * initialized by a call to {@link #initCause}.
	 * 
	 * @param message
	 *            The detail message. The detail message is saved for later
	 *            retrieval by the {@link #getMessage()} method.
	 */
	public WorkflowException(String message) {
		super(message);
	}

	/**
	 * Constructs a new <code>WorkflowException</code> with the specified
	 * cause and a detail message of
	 * {@code (cause==null ? null : cause.toString())} (which typically
	 * contains the class and detail message of {@code cause}). This
	 * constructor is useful for <code>WorkflowException</code> that are
	 * wrappers for other <code>{@link Throwable}</code>s.
	 * 
	 * @param cause
	 *            The cause (which is saved for later retrieval by the
	 *            {@link #getCause()} method). (A {@code null} value is
	 *            permitted, and indicates that the cause is nonexistent or
	 *            unknown.)
	 */
	public WorkflowException(Throwable cause) {
		super(cause);
	}

	/**
	 * Constructs a new <code>WorkflowException</code> with the specified
	 * detail message and cause.
	 * 
	 * @param message
	 *            The detail message (which is saved for later retrieval by the
	 *            {@link #getMessage()} method).
	 * @param cause
	 *            The cause (which is saved for later retrieval by the
	 *            {@link #getCause()} method). (A {@code null} value is
	 *            permitted, and indicates that the cause is nonexistent or
	 *            unknown.)
	 */
	public WorkflowException(String message, Throwable cause) {
		super(message, cause);
	}
}
