/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.exec;

import org.osgi.annotation.versioning.ProviderType;
import com.adobe.granite.workflow.HasMetaData;
import com.adobe.granite.workflow.model.WorkflowModel;
import com.adobe.granite.workflow.model.WorkflowNode;

import java.util.Date;

/**
 * <p>
 * A <code>WorkItem</code> is the unit that is passed through an
 * <code>{@link Workflow}</code> instance of a
 * <code>{@link WorkflowModel}</code>.
 * </p><p>
 * It contains the <code>{@link WorkflowData}</code> the instances acts on and
 * a reference to the {@link WorkflowNode} that describes the underlying
 * workflow step.
 * </p><p>
 * A <code>WorkItem</code> can be considered as a token in a petri net that
 * flows through the net during execution.
 * </p>
 */
@ProviderType
public interface WorkItem extends InboxItem, HasMetaData {
    /**
     * Returns the start time of the <code>WorkflowItem</code>.
     *
     * @return The start time of the <code>WorkflowItem</code>.
     */
    Date getTimeStarted();

    /**
     * Returns the end time of the <code>WorkflowItem</code>.
     *
     * @return The end time of the <code>WorkflowItem</code>.
     */
    Date getTimeEnded();

    /**
     * Returns the <code>{@link Workflow}</code> instance assigned with this
     * <code>WorkflowItem</code>.
     *
     * @return <code>Workflow</code> of the workflow instance assigned with
     *         the <code>WorkflowItem</code>.
     */
    Workflow getWorkflow();

    /**
     * Returns the current <code>{@link WorkflowNode}</code> the
     * <code>WorkflowItem</code> is attached to.
     *
     * @return The current <code>{@link WorkflowNode}</code> of the
     *         <code>WorkflowItem</code>.
     */
    WorkflowNode getNode();

    /**
     * Returns the ID of the <code>WorkflowItem</code>.
     *
     * @return ID of the <code>WorkflowItem</code>.
     */
    String getId();

    /**
     * Returns the <code>{@link WorkflowData}</code> assigned to the
     * <code>WorkflowItem</code>.
     *
     * @return the <code>{@link WorkflowData}</code> of the
     *         <code>WorkflowItem</code>.
     */
    WorkflowData getWorkflowData();

    /**
     * Returns the currently assigned user, respectively the info in which inbox the WorkItem "resides".
     *
     * @return current assignee
     */
    String getCurrentAssignee();

    /**
     * Sets the due time of this workitem.
     * @param dueTime the new due time of this workitem
     */
    void setDueTime(Date dueTime);

    /**
     * Sets the progress begin time for this workitem.
     * @param progressBeginTime the time for when progress should start on this workitem.
     */
    void setProgressBeginTime(Date progressBeginTime);

    /**
     * Sets the priority for this workitem.
     * @see InboxItem#getPriority() for details
     * @param priority the priority of this task.
     */
    void setPriority(Priority priority);
}
